
# Falls die Dateien im Netz liegen und kein Buchstabe vergeben wurde (also \\netzwerokfreigabe), dann funktioniert
# Get-Location nicht !!!




#Öffne alle XML Dateien und passe den SourcePath an

$LokalerPfad = Get-Location
$XmlFilesVL = Get-ChildItem -Path "$LokalerPfad\XML\Office*.xml"
$XmlFilesRetail = Get-ChildItem -Path "$LokalerPfad\XML\*365*.xml"



# Falls keine XML Dateien, dann höre wieder auf. Ansonsten passe alle Pfade an.
if (!($XmlFilesVL)) {
    Write-Host "Keine XML Dateien gefunden." -ForegroundColor Red
    Pause
    Exit
} else {
    # Volume License
    foreach ($item in $XmlFilesVL) {
        $oItem = New-Object System.XML.XMLDocument
        $oItem.Load($item)
        $oItem.Configuration.Add.SourcePath = "$LokalerPfad\VL"
        $oItem.Save($item)
    }
    Write-Host "Volume License wurde angepasst: $LokalerPfad\VL" -ForegroundColor Green

    # 365
    foreach ($item in $XmlFilesRetail) {
        $oItem = New-Object System.XML.XMLDocument
        $oItem.Load($item)
        $oItem.Configuration.Add.SourcePath = "$LokalerPfad\365"
        $oItem.Save($item)
    }
    Write-Host "365 wurde angepasst: $LokalerPfad\365" -ForegroundColor Green
}


Pause
Exit


